'''
Read matrix keyboard for Raspi Pico
by jean-claude.feltes@education.lu

'''
from machine import Pin
import time


#----------------------------------------------

# Internal functions:
def _init_colpins(colpins):
    # colpins as output, set high
    # returns array of colpins
    col = []
    for pin in colpins:
        col.append(Pin(pin, Pin.OUT))
        Pin(pin).value(1)
    return col

def _init_rowpins(rowpins):
    # rowpins as input with pullup
    # returns array of rowpins
    row = []
    for pin in rowpins:
        row.append(Pin(pin, Pin.IN, Pin.PULL_UP))
        
    return row
#-----------------------------------------------------
def init_keyboard(colpins, rowpins, kmap,  debounce = 150):
    global cols, rows, debouncetime, keymap
    keymap = kmap
    debouncetime = debounce
    cols = _init_colpins(colpins)
    rows = _init_rowpins(rowpins)


def getkey():
    '''Read a single character from keyboard
       non blocking
    '''
    global cols, rows, debouncetime
    
    i=0
    key = ''
    for col in cols:
        col.value(0)
        time.sleep_ms(1)
                
        j=0
        for row in rows:
            if (row.value() == 0):
                time.sleep_ms(debouncetime)
                while (row.value == 0):
                    pass
                key = keymap[j][i]
                #print(key)
                break
            
            j += 1
        i += 1    
           
        col.value(1)
    return key

def getstring_showdigits_print(key):
    '''default callback to show digits while typing'''
    print(key, end = '')

def getstring_end_print(s):
    '''default callback for print at end of typing'''
    # delete digits from showdigits
    print('\r', end = '')
    for i in range(0, len(s)):
        print(' ', end = '')
    print('\r', end = '')
    
def getstring(maxlen = 16, timeout = 10,
              callback_showdigits = getstring_showdigits_print,
              callback_end = getstring_end_print,
              enter_key = '#',
              cancel_key = '*'):
    s = ''
    t1 = time.time()
    while True:
        # get key, show digits while typing
        key = getkey()
        
        # get key, end at Enter
        if key == enter_key:
            break
        elif key == cancel_key:
            callback_end(s)
            s=''
            break
        else:
            callback_showdigits(key)
            s = s + key
            
        # break if maxlen or timeout
        if len(s) >= maxlen:
            break
        if time.time() - t1 > timeout:
            break
    callback_end(s)
    return s



     
        
    
#-----------------------------------------------------------
if __name__ == "__main__":
    kmap = [['0', '1', '2', '3'],
           ['4', '5', '6', '7'],
           ['8', '9', '*', '#']]

    colpins = [18, 19, 20, 21]
    rowpins = [15, 16, 17]

    init_keyboard(colpins, rowpins, kmap, 200)

    print("Type on keypad")
    s = getstring()
    print ("RESULT: ",  s, "Length:", len(s))

    '''
    while True:
        key = getkey()
        if len(key):
            print(key, end = '')
    '''        
        
   
