'''
functions for working with DS18x20 temperature sensors
by jean-claude.feltes@education.lu
'''
import machine, onewire, ds18x20, time


#-------------------------------------------------
# Helper function:
def bytearray_to_hexstring(bytes):
    ''' Format bytearray to reader friendly string
    e.g. bytearray(b'\x10\xe5\xa5\xed\x01\x08\x00\xd1')
    ->   10E5A5ED010800D1
    '''
    h = ''
    for i in bytes:
        
        s = hex(i)[2:]
        if len(s) == 1:
            s='0' + s
        s = s.upper()
        h += s
    
    return h

# ------------------------------------------------


def define_pin(iopin):
    # define pin for DS18x20, return sensor object
    ds_pin = machine.Pin(iopin)
    ds_bus = ds18x20.DS18X20(onewire.OneWire(ds_pin))
    return ds_bus

def get_temperatures(ds_bus, addresses):
    # return list of temperatures
    temperatures = []
    for address in addresses:
        ds_bus.convert_temp()  
        temp = ds_bus.read_temp(address)
        temperatures.append(temp)
    return temperatures  
        
def get_temperature_string(ds_bus):
    # return tabseparated temperatures
    s = ''
    addresses = ds_bus.scan()
    for address in addresses:
        ds_bus.convert_temp()  
        temp = ds_bus.read_temp(address)
        s+= str(temp) + '\t'
    return s  
    
#-------------------------------------------------

def get_sensors_info(ds_bus):
    addresses = ds_bus.scan()
    
    addrinfo = 'Found DS devices: \n'
    
    for a in addresses:
        addrinfo += bytearray_to_hexstring(a) + '\n'   
    
    return addresses, addrinfo
#------------------------------------------------------

if __name__ == '__main__':
    
    dsbus = define_pin(16)
    addresses, addrinfo = get_sensors_info(dsbus)
    print(addrinfo)
    print()
    
    temps = get_temperatures(dsbus, addresses)
    print(temps)
    
    temps = get_temperature_string(dsbus)
    print(temps)
    
